/************************************************************************************
* This header file is for Remote application Interface
*
* (c) Copyright 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
************************************************************************************/
#ifndef _NWKAPP_H_
#define _NWKAPP_H_

#include "TS_Interface.h"
#include "FSLProfileInterface.h"
#include "ZRCProfileInterface.h"
#include "ZRCProfileCommands.h"
#include "PushButtonInterface.h"

/******************************************************************************
*******************************************************************************
* Public Macros
*******************************************************************************
******************************************************************************/
#define gAppEvtMsgFromNlme_c                          (1 << 0)
#define gAppEvtMsgFromNlde_c                          (1 << 1)
#define gAppEvtMsgFromPushButton_c                    (1 << 2)
#define gAppEvtMsgFromZRCProfile_c                    (1 << 3)
#define gAppEvtMsgFromFSLProfile_c                    (1 << 4)
#define gAppEvtRxFromUart_c                           (1 << 5)
#define gAppEvtPrintMenu_c                            (1 << 6)
#define gAppEvtTimerTimeout_c                         (1 << 7)
#define gAppEvtStateStart_c                           (1 << 8)
#define gAppEvtStateEnd_c                             (1 << 9)
#define gAppEvtDummyEvent_c                           (1 << 15)

/* Defines for the application to configure the local appCapabilities structure */
#define gAppCapabilities_UseUserString_c              TRUE
#define gAppCapabilities_NrOfSupportedDeviceTypes_c   1
#define gAppCapabilities_NrOfSupportedProfiles_c      3

/* Define for the application to configure the local nwk user string */
#define gUserString_c                                 "Remote Control"

/* Defines for the application to configure the data to send to paired devices */
#define gAppCmdPayload_c                              "abcde"
#define gAppCmdPayloadLength_c                        5   
                            
/* Defines for the application to configure the local list of supported device types */
#define gSupportedDeviceType1_c                       gDeviceType_RemoteControl
#define gSupportedDeviceType2_c                       gDeviceType_Reserved
#define gSupportedDeviceType3_c                       gDeviceType_Reserved

/* Defines for the application to configure the local list of supported profiles */
#define gSupportedProfile1_c                          0x01
#define gSupportedProfile2_c                          0xF0
#define gSupportedProfile3_c                          0xC0
#define gSupportedProfile4_c                          0x00
#define gSupportedProfile5_c                          0x00
#define gSupportedProfile6_c                          0x00
#define gSupportedProfile7_c                          0x00

/* Defines for the application to configure the txOptions when sending commands to paired devices */
#define gTxOptions_UseBroadcast_c                     FALSE
#define gTxOptions_UseTargetLongAddress_c             FALSE
#define gTxOptions_UseAck_c                           TRUE
#define gTxOptions_UseSecurity_c                      TRUE
#define gTxOptions_UseOneChannelOnly_c                FALSE
#define gTxOptions_UseChannelDesignator_c             FALSE
#define gTxOptions_VendorSpecificData_c               TRUE

/* Defines for the application to configure the intermitent Rx mechanism */
#define gNwkDutyCycle_c                               62500 /* MAC symbols */
#define gNwkActivePeriod_c                            30000 /* MAC symbols */

/* Defines for the application to configure the ZRC command to send to paired devices */
#define gAppZRCProfileCmdCode_c                      gZRC_CmdCode_UserCtrlPressed_c
#define gAppZRCCmd_c                                 gZRC_CmdRC_Select_c
#define gAppZRCCmdPayload_c                          "1234"
#define gAppZRCCmdPayloadLength_c                    4
#define gAppZRCDiscoverySearchedPanId_c              0xFFFF
#define gAppZRCDiscoverySearchedShortAddress_c       0xFFFF
#define gAppZRCDiscoverySearchedDeviceType_c         gDeviceType_Wildcard
#define gAppZRCKeyExTransferCount_c                  5
#define gAppZRCRequestAppAcceptToPair_c              TRUE
#define gAppZRCTimeToWaitAppAcceptToPair_c           1000 /* ms */

/* Defines for the application to configure FSL private profile requests */
#define gAppFSLPollInterval_c                         5000 /* (ms) */
#define gAppFSLPollRxOnInterval_c                        0
#define gAppFSLRmtPairRespTimeout_c                   2000
#define gAppFSLFragTxPayloadLength_c                   512
/******************************************************************************
*******************************************************************************
* Public type definitions
*******************************************************************************
******************************************************************************/


/******************************************************************************
*******************************************************************************
* Public Memory Declarations
*******************************************************************************
******************************************************************************/
extern appCapabilities_t  localAppCapabilities;
extern uint8_t            localDeviceTypesList[];
extern uint8_t            localProfilesList[];

/******************************************************************************
*******************************************************************************
* Public Prototypes
*******************************************************************************
******************************************************************************/
void App_Init(void);
void App_MainTask(event_t events);

#endif /* _NWKAPP_H_ */
